/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.utils;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class ScalarYamlConfiguration
extends YamlConfiguration {
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    public static ScalarYamlConfiguration loadConfiguration(File file) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        ScalarYamlConfiguration config = new ScalarYamlConfiguration();
        try {
            config.load(file);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file.getPath().replaceAll("[\r\n]", ""), ex);
        }
        return config;
    }

    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.LITERAL);
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String header = this.buildHeader();
        String dump = this.yaml.dump((Object)this.getValues(false));
        if ("{}\n".equals(dump)) {
            dump = "";
        }
        return header + dump;
    }
}

